/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import me.angel.challenges6t4.challenge.MobRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;

public class MobSpawnOnEatChallenge
extends Challenge {
    private static final float DEFAULT_SPAWN_DISTANCE = 3.0f;
    private static final int DEFAULT_MOB_COUNT = 1;
    private static final String SETTING_SPAWN_DISTANCE = "spawn_distance";
    private static final String SETTING_INCLUDE_BOSSES = "include_bosses";
    private static final String SETTING_DOUBLE_HUNGER_DRAIN = "double_hunger_drain";
    private static final String SETTING_MOB_COUNT = "mob_count";
    public static final float MIN_DISTANCE = 1.0f;
    public static final float MAX_DISTANCE = 10.0f;

    public MobSpawnOnEatChallenge() {
        super("mob_spawn_on_eat", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.mob_spawn_on_eat.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.mob_spawn_on_eat.description"), true, Challenge.MultiplayerStatus.EXPERIMENTAL);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_SPAWN_DISTANCE)) {
            this.setSpawnDistance(3.0f);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_INCLUDE_BOSSES)) {
            this.setIncludeBosses(false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_DOUBLE_HUNGER_DRAIN)) {
            this.setDoubleHungerDrain(false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_MOB_COUNT)) {
            this.setMobCount(1);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    public float getSpawnDistance() {
        return ChallengeSettings.getFloatOption(this.getId(), SETTING_SPAWN_DISTANCE, 3.0f);
    }

    public void setSpawnDistance(float distance) {
        ChallengeSettings.setFloatOption(this.getId(), SETTING_SPAWN_DISTANCE, distance);
    }

    public boolean isIncludeBosses() {
        return ChallengeSettings.getBooleanOption(this.getId(), SETTING_INCLUDE_BOSSES, false);
    }

    public void setIncludeBosses(boolean includeBosses) {
        ChallengeSettings.setBooleanOption(this.getId(), SETTING_INCLUDE_BOSSES, includeBosses);
    }

    public boolean isDoubleHungerDrain() {
        return ChallengeSettings.getBooleanOption(this.getId(), SETTING_DOUBLE_HUNGER_DRAIN, false);
    }

    public void setDoubleHungerDrain(boolean doubleHungerDrain) {
        ChallengeSettings.setBooleanOption(this.getId(), SETTING_DOUBLE_HUNGER_DRAIN, doubleHungerDrain);
    }

    public int getMobCount() {
        return ChallengeSettings.getIntOption(this.getId(), SETTING_MOB_COUNT, 1);
    }

    public void setMobCount(int mobCount) {
        mobCount = Math.max(1, Math.min(50, mobCount));
        ChallengeSettings.setIntOption(this.getId(), SETTING_MOB_COUNT, mobCount);
    }

    public void onPlayerEat(class_1657 player) {
        if (!this.isEnabled() || player.method_7325() || player.method_68878()) {
            return;
        }
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int mobCount = this.getMobCount();
        int successfulSpawns = 0;
        String firstMobName = null;
        for (int i = 0; i < mobCount; ++i) {
            class_1299<?> mobType = MobRegistry.getRandomMob(this.isIncludeBosses());
            float maxSpawnDistance = this.getSpawnDistance();
            float actualSpawnDistance = (float)(Math.random() * (double)maxSpawnDistance);
            class_243 lookVec = player.method_5828(1.0f);
            double randomOffsetX = (Math.random() - 0.5) * 0.5;
            double randomOffsetZ = (Math.random() - 0.5) * 0.5;
            double x = player.method_23317() + (lookVec.field_1352 + randomOffsetX) * (double)actualSpawnDistance;
            double z = player.method_23321() + (lookVec.field_1350 + randomOffsetZ) * (double)actualSpawnDistance;
            double y = player.method_23318();
            class_2338 spawnPos = this.findSuitableSpawnPosition(serverWorld, new class_2338((int)x, (int)y, (int)z), player);
            try {
                class_1297 mob = mobType.method_47821(serverWorld, spawnPos, class_3730.field_16467);
                if (mob == null) continue;
                ++successfulSpawns;
                if (firstMobName != null) continue;
                firstMobName = mob.method_5477().getString();
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to spawn mob: " + e.getMessage());
            }
        }
        if (successfulSpawns > 0) {
            if (successfulSpawns == 1) {
                player.method_7353((class_2561)class_2561.method_43469((String)"challenges6t4.challenge.mob_spawn_on_eat.spawned_single", (Object[])new Object[]{firstMobName}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"challenges6t4.challenge.mob_spawn_on_eat.spawned_multiple", (Object[])new Object[]{successfulSpawns}), true);
            }
        }
    }

    private class_2338 findSuitableSpawnPosition(class_3218 world, class_2338 pos, class_1657 player) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            class_2338 testPos = pos;
            if (attempt > 0) {
                int offsetX = (int)((Math.random() - 0.5) * 4.0);
                int offsetZ = (int)((Math.random() - 0.5) * 4.0);
                testPos = pos.method_10069(offsetX, 0, offsetZ);
            }
            for (int y = testPos.method_10264(); y >= world.method_31607(); --y) {
                class_2338 checkPos = new class_2338(testPos.method_10263(), y, testPos.method_10260());
                class_2338 spawnPos = checkPos.method_10084();
                if (!this.isValidSpawnPosition(world, spawnPos)) continue;
                return spawnPos;
            }
        }
        class_2338 playerPos = player.method_24515();
        for (int y = playerPos.method_10264(); y >= world.method_31607(); --y) {
            class_2338 checkPos = new class_2338(playerPos.method_10263(), y, playerPos.method_10260());
            class_2338 spawnPos = checkPos.method_10084();
            if (!this.isValidSpawnPosition(world, spawnPos)) continue;
            return spawnPos;
        }
        return playerPos;
    }

    private boolean isValidSpawnPosition(class_3218 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!blockState.method_26215() && blockState.method_26227().method_15769() && blockState.method_26212((class_1922)world, pos)) {
            return false;
        }
        class_2338 below = pos.method_10074();
        if ((blockState.method_26227().method_15769() || world.method_8320(below).method_26212((class_1922)world, below)) && blockState.method_26227().method_15769() && !world.method_8320(below).method_26212((class_1922)world, below)) {
            return false;
        }
        class_2338 above = pos.method_10084();
        class_2680 aboveState = world.method_8320(above);
        return !aboveState.method_26212((class_1922)world, above);
    }
}

